structure(list(method = "GET", url = "https://wxs.ign.fr/environnement/geoportail/r/wms?service=wms&request=GetCapabilities", 
    status_code = 200L, headers = structure(list(date = "Thu, 03 Aug 2023 10:22:16 GMT", 
        `content-type` = "text/xml;charset=utf-8", `transfer-encoding` = "chunked", 
        `wl-original-content-type` = "text/xml;charset=utf-8", 
        `cache-control` = "public, max-age=1814400", `access-control-allow-methods` = "GET, POST", 
        `access-control-max-age` = "43200", `access-control-allow-origin` = "*"), class = "httr2_headers"), 
    body = charToRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?><WMS_Capabilities xmlns=\"http://www.opengis.net/wms\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.3.0\" xsi:schemaLocation=\"http://www.opengis.net/wms http://schemas.opengis.net/wms/1.3.0/capabilities_1_3_0.xsd\"><Service><Name>WMS</Name><Title>Service WMS Raster Geoportail Publics</Title><Abstract>Ce service permet la visualisation de couches de données raster IGN au travers d'un flux WMS</Abstract><KeywordList><Keyword>WMS</Keyword><Keyword>Parcelles cadastrales</Keyword><Keyword>Photographies aériennes</Keyword><Keyword>Cartes</Keyword><Keyword>Cartes historiques</Keyword><Keyword>Altitude</Keyword></KeywordList><OnlineResource xlink:href=\"https://wxs.ign.fr\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"/><ContactInformation><ContactPersonPrimary><ContactPerson>Géoportail SAV</ContactPerson><ContactOrganization>IGN</ContactOrganization></ContactPersonPrimary><ContactPosition>custodian</ContactPosition><ContactAddress><AddressType/><Address>73 avenue de Paris</Address><City>Saint Mandé</City><StateOrProvince/><PostCode>94160</PostCode><Country>France</Country></ContactAddress><ContactVoiceTelephone/><ContactFacsimileTelephone/><ContactElectronicMailAddress>geop_services@geoportail.fr</ContactElectronicMailAddress></ContactInformation><Fees>licences</Fees><AccessConstraints>Conditions Générales d'Utilisation disponibles ici : https://geoservices.ign.fr/cgu-licences</AccessConstraints><LayerLimit>2</LayerLimit><MaxWidth>10000</MaxWidth><MaxHeight>10000</MaxHeight></Service><Capability><Request><GetCapabilities><Format>text/xml</Format><DCPType><HTTP><Get><OnlineResource xlink:href=\"https://wxs.ign.fr/environnement/geoportail/r/wms?\" xlink:type=\"simple\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"/></Get></HTTP></DCPType></GetCapabilities><GetMap><Format>image/jpeg</Format><Format>image/png</Format><Format>image/tiff</Format><Format>image/geotiff</Format><Format>image/x-bil;bits=32</Format><Format>text/asc</Format><DCPType><HTTP><Get><OnlineResource xlink:href=\"https://wxs.ign.fr/environnement/geoportail/r/wms?\" xlink:type=\"simple\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"/></Get></HTTP></DCPType></GetMap><GetFeatureInfo><Format>text/plain</Format><Format>text/html</Format><Format>text/xml</Format><Format>application/xml</Format><Format>application/json</Format><DCPType><HTTP><Get><OnlineResource xlink:href=\"https://wxs.ign.fr/environnement/geoportail/r/wms?\" xlink:type=\"simple\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"/></Get></HTTP></DCPType></GetFeatureInfo></Request><Exception><Format>XML</Format></Exception><Layer><Title>cache IGN</Title><Abstract>Cache IGN</Abstract><CRS>CRS:84</CRS><CRS>EPSG:2154</CRS><CRS>IGNF:LAMB93</CRS><CRS>EPSG:21781</CRS><CRS>EPSG:23030</CRS><CRS>EPSG:23031</CRS><CRS>EPSG:23032</CRS><CRS>EPSG:27561</CRS><CRS>IGNF:LAMB1</CRS><CRS>EPSG:27562</CRS><CRS>IGNF:LAMB2</CRS><CRS>EPSG:27563</CRS><CRS>IGNF:LAMB3</CRS><CRS>EPSG:27564</CRS><CRS>IGNF:LAMB4</CRS><CRS>EPSG:27571</CRS><CRS>IGNF:LAMB1C</CRS><CRS>EPSG:27572</CRS><CRS>IGNF:LAMB2C</CRS><CRS>IGNF:LAMBE</CRS><CRS>EPSG:27573</CRS><CRS>IGNF:LAMB3C</CRS><CRS>EPSG:27574</CRS><CRS>IGNF:LAMB4C</CRS><CRS>EPSG:27581</CRS><CRS>EPSG:27582</CRS><CRS>EPSG:27583</CRS><CRS>EPSG:27584</CRS><CRS>EPSG:27591</CRS><CRS>EPSG:27592</CRS><CRS>EPSG:27593</CRS><CRS>EPSG:27594</CRS><CRS>EPSG:2969</CRS><CRS>IGNF:GUADFM49U20</CRS><CRS>EPSG:2970</CRS><CRS>IGNF:GUAD48UTM20</CRS><CRS>EPSG:2971</CRS><CRS>IGNF:CSG67UTM22</CRS><CRS>EPSG:2972</CRS><CRS>IGNF:UTM22RGFG95</CRS><CRS>EPSG:2973</CRS><CRS>IGNF:MART38UTM20</CRS><CRS>EPSG:2975</CRS><CRS>IGNF:RGR92UTM40S</CRS><CRS>EPSG:2976</CRS><CRS>IGNF:TAHI51UTM06S</CRS><CRS>EPSG:2977</CRS><CRS>EPSG:2978</CRS><CRS>EPSG:2980</CRS><CRS>IGNF:MAYO50UTM38S</CRS><CRS>EPSG:2981</CRS><CRS>EPSG:2987</CRS><CRS>IGNF:STPM50UTM21</CRS><CRS>EPSG:2988</CRS><CRS>IGNF:WALL78UTM1S</CRS><CRS>EPSG:2989</CRS><CRS>EPSG:2990</CRS><CRS>EPSG:3034</CRS><CRS>EPSG:3035</CRS><CRS>EPSG:3042</CRS><CRS>EPSG:3043</CRS><CRS>EPSG:3044</CRS><CRS>EPSG:3170</CRS><CRS>EPSG:3171</CRS><CRS>EPSG:3172</CRS><CRS>EPSG:32620</CRS><CRS>IGNF:UTM20W84GUAD</CRS><CRS>IGNF:WGS84UTM20</CRS><CRS>IGNF:UTM20W84MART</CRS><CRS>IGNF:UTM20W84</CRS><CRS>EPSG:32621</CRS><CRS>EPSG:32622</CRS><CRS>EPSG:32630</CRS><CRS>IGNF:UTM30W84</CRS><CRS>EPSG:32631</CRS><CRS>IGNF:UTM31W84</CRS><CRS>EPSG:32632</CRS><CRS>IGNF:UTM32W84</CRS><CRS>EPSG:32701</CRS><CRS>IGNF:UTM01SW84</CRS><CRS>EPSG:32705</CRS><CRS>EPSG:32706</CRS><CRS>EPSG:32707</CRS><CRS>EPSG:32738</CRS><CRS>EPSG:32739</CRS><CRS>IGNF:UTM39SW84</CRS><CRS>EPSG:32740</CRS><CRS>EPSG:3296</CRS><CRS>IGNF:RGPFUTM5S</CRS><CRS>EPSG:3297</CRS><CRS>IGNF:RGPFUTM6S</CRS><CRS>EPSG:3298</CRS><CRS>IGNF:RGPFUTM7S</CRS><CRS>EPSG:3302</CRS><CRS>IGNF:IGN63UTM7S</CRS><CRS>EPSG:3303</CRS><CRS>EPSG:3304</CRS><CRS>IGNF:TAHI79UTM6S</CRS><CRS>EPSG:3305</CRS><CRS>EPSG:3306</CRS><CRS>EPSG:3727</CRS><CRS>EPSG:3857</CRS><CRS>EPSG:3942</CRS><CRS>IGNF:RGF93CC42</CRS><CRS>EPSG:3943</CRS><CRS>IGNF:RGF93CC43</CRS><CRS>EPSG:3944</CRS><CRS>IGNF:RGF93CC44</CRS><CRS>EPSG:3945</CRS><CRS>IGNF:RGF93CC45</CRS><CRS>EPSG:3946</CRS><CRS>IGNF:RGF93CC46</CRS><CRS>EPSG:3947</CRS><CRS>IGNF:RGF93CC47</CRS><CRS>EPSG:3948</CRS><CRS>IGNF:RGF93CC48</CRS><CRS>EPSG:3949</CRS><CRS>IGNF:RGF93CC49</CRS><CRS>EPSG:3950</CRS><CRS>IGNF:RGF93CC50</CRS><CRS>EPSG:4171</CRS><CRS>IGNF:RGF93G</CRS><CRS>EPSG:4258</CRS><CRS>EPSG:4275</CRS><CRS>EPSG:4326</CRS><CRS>EPSG:4463</CRS><CRS>EPSG:4467</CRS><CRS>IGNF:RGSPM06U21</CRS><CRS>EPSG:4470</CRS><CRS>EPSG:4471</CRS><CRS>IGNF:RGM04UTM38S</CRS><CRS>EPSG:4558</CRS><CRS>EPSG:4559</CRS><CRS>EPSG:4621</CRS><CRS>EPSG:4622</CRS><CRS>EPSG:4623</CRS><CRS>EPSG:4624</CRS><CRS>EPSG:4625</CRS><CRS>EPSG:4626</CRS><CRS>EPSG:4627</CRS><CRS>EPSG:4628</CRS><CRS>EPSG:4629</CRS><CRS>EPSG:4630</CRS><CRS>EPSG:4632</CRS><CRS>EPSG:4633</CRS><CRS>EPSG:4636</CRS><CRS>EPSG:4637</CRS><CRS>EPSG:4638</CRS><CRS>EPSG:4639</CRS><CRS>EPSG:4641</CRS><CRS>EPSG:4642</CRS><CRS>EPSG:4643</CRS><CRS>EPSG:4644</CRS><CRS>EPSG:4687</CRS><CRS>EPSG:4688</CRS><CRS>EPSG:4689</CRS><CRS>EPSG:4690</CRS><CRS>EPSG:4691</CRS><CRS>EPSG:4692</CRS><CRS>EPSG:4749</CRS><CRS>EPSG:4807</CRS><CRS>IGNF:CSG67GEO</CRS><CRS>IGNF:GUAD48GEO</CRS><CRS>IGNF:GUADFM49GEO</CRS><CRS>IGNF:MART38GEO</CRS><CRS>IGNF:MAYO50GEO</CRS><CRS>IGNF:REUN47GAUSSL</CRS><CRS>IGNF:REUN47GEO</CRS><CRS>IGNF:RGFG95GEO</CRS><CRS>IGNF:STPM50GEO</CRS><CRS>IGNF:WGS84G</CRS><Layer queryable=\"1\"><Name>FORETS.PUBLIQUES</Name><Title>Forêts publiques</Title><Abstract>Localisation des forêts publiques domaniales et non domaniales (communales, sectionales, départementales et d'établissements publics) gérées par l'Office national des forêts (ONF).</Abstract><KeywordList><Keyword>FORETS</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=ONF_PARCELLES_PUBLIQUES.xml\" xlink:type=\"simple\"/></MetadataURL><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=ONF_FORETS_PUBLIQUES.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>FORETS PUBLIQUES ONF</Name><Title>FORETS PUBLIQUES ONF</Title><Abstract>Légende des forêts publiques ONF</Abstract><LegendURL height=\"78\" width=\"302\"><Format>image/png</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/onf_forets_publiques.png\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>GEOGRAPHICALGRIDSYSTEM.DFCI</Name><Title>Carroyage DFCI</Title><Abstract>Le « carroyage DFCI » est un système de maillage géographique utilisé en France par les acteurs de la Défense des Forêts Contre les Incendies (DFCI). Le territoire métropolitain est couvert par des carrés de 100 km de côté, identifiables par deux lettres. Chaque carré de 100 km est divisé en 25 carrés de 20 km de côté, numérotés par des chiffres pairs de 0 à 8. Chaque carré de 20 km est divisé en 100 carrés de 2 km de côté, numérotés par un groupe composé d'une lettre et d'un chiffre. L'unité élémentaire est un carreau de 2 kilomètres de côté, défini par 6 caractères (exemple : KD42F7). Pour désigner un point à l'intérieur de l'unité élémentaire, la précision est obtenue en découpant ce carré en cinq zones numérotées de 1 à 5. Il a été créé sur une grille qui s'appuie sur la projection Lambert II étendue. Depuis 2009, il est re-projeté en Lambert 93 avec une légère déformation des angles et des surfaces. Carroyage DFCI (2 km) : Chaque carré de 20 km est divisé en 100 carrés de 2 km de côté, numérotés par un groupe composé d'une lettre et d'un chiffre. Les carrés de 2 km sont dénommés de A à L (sauf I et J) pour les abscisses, et numérotés de 0 à 9 pour les ordonnées. Date des données : 7 juin 2016 Source : couches 100, 50, 20 et 2 km : Entente Valablre - PôNT, couche 1 km : avec l'aimable autorisation de Geonov (www.geonov.fr)</Abstract><KeywordList><Keyword>DFCI</Keyword></KeywordList><EX_GeographicBoundingBox><westBoundLongitude>-5.150472715</westBoundLongitude><eastBoundLongitude>9.570543239</eastBoundLongitude><southBoundLatitude>41.325209636</southBoundLatitude><northBoundLatitude>51.099054184</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"1065388.000000000\" maxy=\"6638834.000000000\" minx=\"-573348.000000000\" miny=\"5060429.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=DFCI.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer><Name>LANDCOVER.FORESTINVENTORY.V1</Name><Title>Carte forestière v1 (1987-2004)</Title><Abstract>La cartographie forestière est une base de données cartographique des formations végétales forestières et naturelles. Elle couvre l'ensemble du territoire de France métropolitaine. Elle est réalisée par interprétation de photographies aériennes infrarouges et affinée par des contrôles sur le terrain (le seuil minimal de surface cartographiée est de 2,25 ha).</Abstract><KeywordList><Keyword>Occupation des terres</Keyword></KeywordList><EX_GeographicBoundingBox><westBoundLongitude>-5.150472715</westBoundLongitude><eastBoundLongitude>9.570543239</eastBoundLongitude><southBoundLatitude>41.325209636</southBoundLatitude><northBoundLatitude>51.099054184</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"1065388.000000000\" maxy=\"6638834.000000000\" minx=\"-573348.000000000\" miny=\"5060429.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=IFN_BDForet.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>LANDCOVER.FORESTINVENTORY.V2</Name><Title>Carte forestière (v2 : 2006-)</Title><Abstract>Localisation de 32 types de formations végétales sur le territoire. Carte en cours de réalisation depuis 2006.</Abstract><KeywordList><Keyword>Forêt</Keyword></KeywordList><EX_GeographicBoundingBox><westBoundLongitude>-5.150472715</westBoundLongitude><eastBoundLongitude>9.570543239</eastBoundLongitude><southBoundLatitude>41.325209636</southBoundLatitude><northBoundLatitude>51.099054184</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"1065388.000000000\" maxy=\"6638834.000000000\" minx=\"-573348.000000000\" miny=\"5060429.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=IFN_BDForet.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>LANDCOVER.FORESTINVENTORY.V2</Name><Title>Données LANDCOVER.FORESTINVENTORY.V2</Title><Abstract>Style et légende associés au flux LANDCOVER.FORESTINVENTORY.V2</Abstract><LegendURL height=\"69\" width=\"300\"><Format>image/png</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LANDCOVER.FORESTINVENTORY.V2-legend.png\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.APB</Name><Title>Biotopes d'espèces protégées</Title><Abstract>Conservation de l'habitat d'espèces protégées. Outil réglementaires de niveau départemental. mise à jour 04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.APG</Name><Title>Arrêtés de protection de géotope</Title><Abstract>Sites d'intérêt géologique faisant l'objet d’une interdiction de destruction, d'altération ou de dégradation du site, ainsi que de prélèvement, de destruction ou de dégradation de fossiles, minéraux et concrétions présents sur ces sites appelés « aires de protection de géotope».</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.APHN</Name><Title>Arrêtés de protection d’habitats naturels</Title><Abstract>Dispositif visant à protéger un habitat naturel (récif corallien, tourbière, prairie, etc.) en tant que tel, sans qu'il soit besoin d'établir qu'il constitue par ailleurs un habitat d'espèces protégées. Mise à jour 04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>EPSG:32742</CRS><CRS>IGNF:UTM42SW84</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><CRS>EPSG:32743</CRS><CRS>IGNF:UTM43SW84</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>82.645006139</eastBoundLongitude><southBoundLatitude>-53.627912701</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"9200000.000000000\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-7100000.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.BIOS</Name><Title>Réserves de biosphère</Title><Abstract>Réserves naturelles reconnues par le Programme sur l'Homme et la Biosphère créé par l'Unesco. 09-2022</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.GP</Name><Title>Géoparcs</Title><Abstract>Les géoparcs mondiaux UNESCO sont des espaces géographiques unifiés, où les sites et paysages de portée géologique internationale sont gérés selon un concept global de protection, d’éducation et de développement durable</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.INPG</Name><Title>Inventaire National du Patrimoine Géologique (INPG)</Title><Abstract>L'Inventaire National du Patrimoine Géologique (INPG) est un programme initié en 2007 de connaissance géologique du territoire métropolitain et outre-mer, dans lequel chaque site géologique naturel est renseigné sur une application web dédiée (InvenTerre) de façon textuelle avec une évaluation patrimoniale et une cartographie associées.</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>EPSG:32742</CRS><CRS>IGNF:UTM42SW84</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><CRS>EPSG:32743</CRS><CRS>IGNF:UTM43SW84</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>82.645006139</eastBoundLongitude><southBoundLatitude>-53.627912701</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"9200000.000000000\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-7100000.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.MNHN.CDL.PARCELS</Name><Title>Conservatoire du littoral - sites sous responsabilité du conservatoire</Title><Abstract>Les sites du conservatoire du littoral ont pour vocation la sauvegarde des espaces côtiers et lacustres. Leur accès au public est encouragé mais reste défini dans des limites compatibles avec la vulnérabilité de chaque site</Abstract><KeywordList><Keyword>Littoral</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.MNHN.CDL.PERIMETER</Name><Title>Conservatoire du littoral : Les périmètres autorisés</Title><Abstract>Les sites du conservatoire du littoral ont pour vocation la sauvegarde des espaces côtiers et lacustres. Leur accès au public est encouragé mais reste défini dans des limites compatibles avec la vulnérabilité de chaque site.</Abstract><KeywordList><Keyword>Littoral</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.MNHN.RN.PERIMETER</Name><Title>périmètres de protection de réserves naturelles</Title><Abstract>Un périmètre de protection peut être institué en périphérie d’une réserve naturelle. Il concerne des espaces qui n’ont pas été classés en réserve et qui constituent une zone « tampon » autour de l’espace classé. Ils améliorent les échanges écologiques entre la réserve et sa périphérie. 04-2023</Abstract><KeywordList><Keyword>ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>EPSG:32742</CRS><CRS>IGNF:UTM42SW84</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><CRS>EPSG:32743</CRS><CRS>IGNF:UTM43SW84</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>82.645006139</eastBoundLongitude><southBoundLatitude>-53.627912701</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"9200000.000000000\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-7100000.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.PN</Name><Title>Parcs nationaux</Title><Abstract>Les parcs nationaux sont de vastes espaces protégés terrestres ou marins dont le patrimoine naturel est exceptionnel, et dont le but est à la fois de protéger des processus écologiques à large échelle et de fournir des possibilités de découverte de la nature. Mise à jour 04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.PNM</Name><Title>Parcs naturels marins</Title><Abstract>Zones maritimes identifiées pour leur biodiversité ou par les activités humaines faisant l'objet de protection. &lt;/br&gt;&lt;a href=\"http://www.geoportail.gouv.fr/depot/fiches/mnhn/actualite_donnees_mnhn.pdf\" alt=\"Date des données\" target=\"_blank\"&gt;Date des données&lt;/a&gt;</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.PNR</Name><Title>Parcs naturels régionaux</Title><Abstract>Les parcs naturels régionaux ont pour but de valoriser de vastes espaces de fort intérêt culturel et naturel, et de veiller au développement durable de ces territoires dont le caractère rural est souvent très affirmé. 04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.PRSF</Name><Title>Points de Rencontre de Secours en Forêt (PRSF)</Title><Abstract>Les Points de Rencontre de Secours en Forêt (PRSF) sont supposées connus des services de secours. Ils permettent de faciliter la localisation d'un blessé par les services de secours.</Abstract><KeywordList><Keyword>forêt</Keyword><Keyword>secours</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MTD_Produit_Vecteur.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>POINT RENCONTRE SECOURS FORET</Name><Title>POINT RENCONTRE SECOURS FORET</Title><Abstract>Légende Points de Rencontre de Secours en Forêt (PRSF)</Abstract><LegendURL height=\"59\" width=\"300\"><Format>image/png</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/PROTECTEDAREAS.PRSF-legend.png\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.RB</Name><Title>Réserves biologiques</Title><Abstract>Une réserve biologique est un espace protégé en milieu forestier ou en milieu associé à la forêt (landes, mares, tourbières, dunes). Ce statut s'applique aux forêts gérées par l'Office National des Forêts et a pour but la protection d'habitats remarquables ou représentatifs. &lt;br/&gt;&lt;a href=\"http://www.geoportail.gouv.fr/depot/fiches/mnhn/actualite_donnees_mnhn.pdf\" alt=\"Date des données\" target=\"_blank\"&gt;Date des données&lt;/a&gt;</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.RIPN</Name><Title>Réserves Intégrales de Parcs Nationaux</Title><Abstract>Au sein d'un cœur de parc national, il peut être institué une « réserve intégrale » afin d'assurer, dans un but scientifique, une protection plus grande de certains éléments de la faune et de la flore. 05-2022</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.RN</Name><Title>Réserves naturelles nationales</Title><Abstract>Les réserves naturelles sont des espaces protégés terrestres ou marins dont le patrimoine naturel est exceptionnel, tant sur le plan de la biodiversité que parfois sur celui de la géodiversité. 04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>EPSG:32742</CRS><CRS>IGNF:UTM42SW84</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><CRS>EPSG:32743</CRS><CRS>IGNF:UTM43SW84</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>82.645006139</eastBoundLongitude><southBoundLatitude>-53.627912701</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"9200000.000000000\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-7100000.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.RNCF</Name><Title>Réserves nationales de chasse et de faune sauvage</Title><Abstract>Les réserves nationales de chasse et de faune sauvage sont des espaces protégés terrestres ou marins dont la gestion est principalement assurée par l'Office National de la Chasse et de la Faune Sauvage.09-2022</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.SIC</Name><Title>Sites Natura 2000 au titre de la Directive Habitats</Title><Abstract>Le réseau Natura 2000 s'inscrit au coeur de la politique de conservation de la nature de l'Union européenne et est un élément clé de l'objectif visant à enrayer l'érosion de la biodiversité.04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZNIEFF1</Name><Title>Zones écologiques de nature remarquable (ZNIEFF1)</Title><Abstract>Inventaire des espaces naturels abritant la nature remarquable 09-2022</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZNIEFF1.SEA</Name><Title>Zones naturelles d’intérêt écologique faunistique et floristique (ZNIEFF) marine type I</Title><Abstract>Espaces marin homogènes d’un point de vue écologique abritant au moins une espèce ou un habitat rare ou menacé, d’intérêt local ou régional, national ou communautaire. Espaces marin d’intérêt fonctionnel pour le fonctionnement écologique local.</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZNIEFF2</Name><Title>Zones fonctionnelles de nature remarquable (ZNIEFF2)</Title><Abstract>Inventaire des espaces fonctionnels indispensables à la nature remarquable.&lt;/br&gt;&lt;a href=\"http://www.geoportail.gouv.fr/depot/fiches/mnhn/actualite_donnees_mnhn.pdf\" alt=\"Date des données\" target=\"_blank\"&gt;Date des données&lt;/a&gt;</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZNIEFF2.SEA</Name><Title>Zones naturelles d’intérêt écologique faunistique et floristique (ZNIEFF) marine type II</Title><Abstract>Grands ensembles naturels ou peu modifiés marin offrant des potentialités biologiques importantes.</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZPR</Name><Title>Zones de protection renforcée</Title><Abstract>L'arrêté préfectoral fixant la liste départementale de sites d'intérêt géologique est un outil règlementaire qui vise à protéger, par des mesures générales, les sites géologiques qui sont mentionnés en son sein. Il s'agit d'un des deux outils mis en place par le décret du 28 décembre 2015 codifié aux articles R.411-17-1 et 17-2 du code de l'environnement et précisé par la Note du 1er décembre 2016 relative à la protection des sites d'intérêt géologique</Abstract><KeywordList><Keyword>protection</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>EPSG:32742</CRS><CRS>IGNF:UTM42SW84</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><CRS>EPSG:32743</CRS><CRS>IGNF:UTM43SW84</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>82.645006139</eastBoundLongitude><southBoundLatitude>-53.627912701</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"9200000.000000000\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-7100000.000000000\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>nolegend</Name><Title>Données sans légende</Title><Abstract>Sans aucun fichier de légende</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDAREAS.ZPS</Name><Title>Sites NATURA 2000 au titre de la Directive Oiseaux</Title><Abstract>Le réseau Natura 2000 s'inscrit au coeur de la politique de conservation de la nature de l'Union européenne et est un élément clé de l'objectif visant à enrayer l'érosion de la biodiversité.04-2023</Abstract><KeywordList><Keyword>Ecologie</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer><Layer queryable=\"1\"><Name>PROTECTEDSITES.MNHN.RESERVES-REGIONALES</Name><Title>Réserves naturelles régionales</Title><Abstract>Les réserves naturelles régionales sont gérées prioritairement à des fins de conservation de la nature. Elles sont placées sous la responsabilité exclusive des conseils régionaux.04-2023</Abstract><KeywordList><Keyword>Biodiversité</Keyword></KeywordList><CRS>IGNF:RGR92GEO</CRS><CRS>IGNF:RGM04GEO</CRS><CRS>IGNF:CSG67UTM21</CRS><CRS>EPSG:3312</CRS><CRS>EPSG:3313</CRS><EX_GeographicBoundingBox><westBoundLongitude>-63.372521503</westBoundLongitude><eastBoundLongitude>55.925864577</eastBoundLongitude><southBoundLatitude>-21.475586668</southBoundLatitude><northBoundLatitude>51.312119281</northBoundLatitude></EX_GeographicBoundingBox><BoundingBox CRS=\"EPSG:3857\" maxx=\"6225638.766865120\" maxy=\"6676690.825125160\" minx=\"-7054596.823974940\" miny=\"-2448678.407635810\"/><MetadataURL type=\"GEOPORTAIL\"><Format>xml</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/catalogue/geoportail/csw?service=CSW&amp;version=2.0.2&amp;request=GetRecordById&amp;Id=MNHN.xml\" xlink:type=\"simple\"/></MetadataURL><Style><Name>normal</Name><Title>Légende générique</Title><Abstract>Fichier de légende générique – pour la compatibilité avec certains systèmes</Abstract><LegendURL height=\"200\" width=\"200\"><Format>image/jpeg</Format><OnlineResource xlink:href=\"https://wxs.ign.fr/static/legends/LEGEND.jpg\" xlink:type=\"simple\"/></LegendURL></Style><MinScaleDenominator>267.857142857</MinScaleDenominator><MaxScaleDenominator>559082264.285714269</MaxScaleDenominator></Layer></Layer></Capability></WMS_Capabilities>")), class = "httr2_response")
